export const intervals = [
  "1m",
  "3m",
  "5m",
  "15m",
  "30m",
  "1h",
  "2h",
  "4h",
  "6h",
  "12h",
  "1d",
  "3d",
  "1w",
];

export const supported_resolutions_provider = {
  native: [
    "1",
    "3",
    "5",
    "15",
    "30",
    "60",
    "120",
    "240",
    "360",
    "720",
    "D",
    "3D",
    "W",
  ],
  binance: [
    "1",
    "3",
    "5",
    "15",
    "30",
    "60",
    "120",
    "240",
    "360",
    "480",
    "720",
    "D",
  ],
  kraken: ["1", "5", "15", "30", "60", "240", "1440", "10080", "21600"],
  binanceus: [
    "1",
    "3",
    "5",
    "15",
    "30",
    "60",
    "120",
    "240",
    "360",
    "480",
    "720",
    "D",
  ],
  kucoin: ["1", "5", "15", "30", "60", "240", "D"],
  bitget: ["1", "5", "15", "30", "60", "240", "360", "720", "D"],
  okx: ["1", "3", "5", "15", "30", "60", "120", "240"],
  xt: [
    "1",
    "3",
    "5",
    "15",
    "30",
    "60",
    "120",
    "240",
    "360",
    "480",
    "720",
    "D",
    "3D",
    "W",
  ],
};

export const resolutionMap_provider = {
  native: {
    "1": "1m",
    "3": "3m",
    "5": "5m",
    "15": "15m",
    "30": "30m",
    "60": "1h",
    "120": "2h",
    "240": "4h",
    "360": "6h",
    "720": "12h",
    D: "1d",
    "3D": "3d",
    W: "1w",
  },
  binance: {
    "1": "1m",
    "3": "3m",
    "5": "5m",
    "15": "15m",
    "30": "30m",
    "60": "1h",
    "120": "2h",
    "240": "4h",
    "360": "6h",
    "480": "8h",
    "720": "12h",
    D: "1d",
  },
  kraken: {
    "1": "1m",
    "5": "5m",
    "15": "15m",
    "30": "30m",
    "60": "1h",
    "240": "4h",
    "1440": "1d",
    "10080": "1w",
    "21600": "1M",
  },
  binanceus: {
    "1": "1m",
    "3": "3m",
    "5": "5m",
    "15": "15m",
    "30": "30m",
    "60": "1h",
    "120": "2h",
    "240": "4h",
    "360": "6h",
    "480": "8h",
    "720": "12h",
    D: "1d",
  },
  kucoin: {
    "1": "1m",
    "5": "5m",
    "15": "15m",
    "30": "30m",
    "60": "1h",
    "240": "4h",
    "1D": "1d",
  },
  bitget: {
    "1": "1m",
    "5": "5m",
    "15": "15m",
    "30": "30m",
    "60": "1h",
    "240": "4h",
    "360": "6h",
    "720": "12h",
    "1D": "1d",
  },
  okx: {
    "1": "1m",
    "3": "3m",
    "5": "5m",
    "15": "15m",
    "30": "30m",
    "60": "1h",
    "120": "2h",
    "240": "4h",
  },
  xt: {
    "1": "1m",
    "3": "3m",
    "5": "5m",
    "15": "15m",
    "30": "30m",
    "60": "1h",
    "120": "2h",
    "240": "4h",
    "360": "6h",
    "480": "8h",
    "720": "12h",
    D: "1d",
    "3D": "3d",
    W: "1w",
  },
};

export const resolutionMap = resolutionMap_provider["binance"];

export const intervalDurations = {
  "1": 86400000,
  "3": 259200000,
  "5": 432000000,
  "15": 1296000000,
  "30": 2592000000,
  "60": 5184000000,
  "120": 10368000000,
  "240": 20736000000,
  "360": 31104000000,
  "480": 41472000000,
  "720": 62208000000,
  "1D": 124416000000,
  "3D": 373248000000,
  W: 871488000000,
};
